/********************************************************
** Copyright 1999 Earth Resource Mapping Ltd.
** This document contains proprietary source code of
** Earth Resource Mapping Ltd, and can only be used under
** one of the three licenses as described in the 
** license.txt file supplied with this distribution. 
** See separate license.txt file for license details 
** and conditions.
**
** This software is covered by US patent #6,442,298,
** #6,102,897 and #6,633,688.  Rights to use these patents 
** is included in the license agreements.
**
** FILE:   	NCSPrefs.h
** CREATED:	Fri Jun  4 18:05:04 WST 1999
** AUTHOR: 	Mark Sheridan
** PURPOSE:	NCS Preferences header.
** EDITS:
** [01]	 ny	31Oct00	Merge WinCE/PALM SDK changes
 *******************************************************/

#ifndef NCSPREFS_H
#define NCSPREFS_H

#include "NCSUtil.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "NCSTypes.h"
#include "NCSErrors.h"
#include "NCSMutex.h"
#include "NCSMalloc.h"
#ifdef PALM
#include <Preferences.h>
#endif	/* PALM */

#define NCSPREF_DEFAULT_BASE_KEY "Software\\Earth Resource Mapping\\Image Web Server"

#ifdef PALM
#define NCS_PALM_MAX_PREFS 64
#define NCS_PALM_MAX_PREF_LENGTH 256
#endif	/* PALM */
/* 
**
** Utility functions - create delete machine or user level keys
**
*/

void NCSLockRegistryAccess();
void NCSUnLockRegistryAccess();

void NCSPrefInit(void);
void NCSPrefFini(void);
NCSError NCSPrefCreateUserKey(char *pKeyName );
NCSError NCSPrefCreateMachineKey(char *pKeyName );
NCSError NCSPrefSetMachineKey(char *pKeyName );
NCSError NCSPrefSetUserKey(char *pKeyName );
char *NCSPrefGetMachineKey(void);
char *NCSPrefGetUserKey(void);

/* 
**
** Machine/Global level preference functions
** Base key is HKEY_LOCAL_MACHINE
**
*/
NCSError NCSPrefGetString(char *pKeyName, char **pString );
NCSError NCSPrefSetString(char *pKeyName, char *pString );
NCSError NCSPrefGetDouble(char *pKeyName, IEEE8 *pValue );
NCSError NCSPrefSetDouble(char *pKeyName, IEEE8 dValue );
NCSError NCSPrefGetInt(char *pKeyName, INT32 *pValue );
NCSError NCSPrefSetInt(char *pKeyName, INT32 nValue);
NCSError NCSPrefSetBoolean(char *pKeyname, BOOLEAN bValue );
NCSError NCSPrefGetBoolean(char *pKeyName, BOOLEAN *pValue );
NCSError NCSPrefDeleteValue(char *pKeyName);

/* 
**
** User level preference functions
** Base key is HKEY_CURRENT_USER
**
*/
NCSError NCSPrefGetUserString(char *pKeyName, char **pString );
NCSError NCSPrefSetUserString(char *pKeyName, char *pString );
NCSError NCSPrefGetUserDouble(char *pKeyName, IEEE8 *pValue );
NCSError NCSPrefSetUserDouble(char *pKeyName, IEEE8 dValue );
NCSError NCSPrefGetUserInt(char *pKeyName, INT32 *pValue );
NCSError NCSPrefSetUserInt(char *pKeyName, INT32 nValue );
NCSError NCSPrefSetUserBoolean(char *pKeyname, BOOLEAN bValue );
NCSError NCSPrefGetUserBoolean(char *pKeyName, BOOLEAN *pValue );
NCSError NCSPrefDeleteValueUser(char *pKeyName);

#ifdef __cplusplus
}
#endif

#endif /* NCSPREFS_H */
